//+------------------------------------------------------------------+
//|                                                                  |
//|                      based on code in THV T3 Trix.mq4            |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Paradox"
#property link      ""

#property indicator_separate_window
#property indicator_buffers 8
#property indicator_color1 Lime  
#property indicator_color2 Red
#property indicator_color3 Lime  
#property indicator_color4 Red
#property indicator_color5 CLR_NONE
#property indicator_color6 CLR_NONE
#property indicator_color7 Red
#property indicator_color8 Lime

#property indicator_width1 1
#property indicator_width2 1
#property indicator_width3 2
#property indicator_width4 2


//---- input parameters
extern int       FastPeriod=20;
extern int       SlowPeriod=30;
extern bool ShowDivergence  = false;
extern bool ShowDivergenceLines = false;
extern bool ShowDivergencePriceLines = false;
  
double            hot=1.2;

//---- buffers
double FastUp[];
double FastDown[];
double SlowUp[];
double SlowDown[];
double Fast[];
double Slow[];
double Peak[];
double Trough[];


double c1=0,c2=0,c3=0,c4=0;
double FastWeight1=0,FastWeight2=0,SlowWeight1=0,SlowWeight2=0;

double e1x=0,e2x=0,e3x=0,e4x=0,e5x=0,e6x=0;
double d1x=0,d2x=0,d3x=0,d4x=0,d5x=0,d6x=0;
double FastTrixPrev=0, SlowTrixPrev=0;  
int RedoBarCount = 10;

bool FirstRun = true;
int ObjectId;
int WindowId;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
//---- indicators
   IndicatorBuffers(8);
   IndicatorDigits(7);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,FastUp);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,FastDown);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,SlowUp);
   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(3,SlowDown);
   SetIndexBuffer(4,Fast);
   SetIndexBuffer(5,Slow);
   

   SetIndexBuffer(6,Peak); 
   SetIndexBuffer(7,Trough);
   SetIndexStyle( 6, DRAW_ARROW ); SetIndexArrow(6,234);
   SetIndexStyle( 7, DRAW_ARROW ); SetIndexArrow(7,233);  

         
//----
   WindowId = WindowFind(WindowExpertName());
   
   
   ObjectCreate("Trix4_EOB" + DoubleToStr(WindowId,0),OBJ_HLINE,WindowId,NULL,0.0008);
   ObjectSet("Trix4_EOB" + DoubleToStr(WindowId,0),OBJPROP_COLOR,Red);
   ObjectCreate("Trix4_OB" + DoubleToStr(WindowId,0),OBJ_HLINE,WindowId,NULL,0.0005);
   ObjectSet("Trix4_OB" + DoubleToStr(WindowId,0),OBJPROP_COLOR,FireBrick);   
   ObjectSet("Trix4_OB" + DoubleToStr(WindowId,0),OBJPROP_STYLE,STYLE_DOT);   
   
   ObjectCreate("Trix4_EOS" + DoubleToStr(WindowId,0),OBJ_HLINE,WindowId,NULL,-0.0008);
   ObjectSet("Trix4_EOS" + DoubleToStr(WindowId,0),OBJPROP_COLOR,Lime);
   ObjectCreate("Trix4_OS" + DoubleToStr(WindowId,0),OBJ_HLINE,WindowId,NULL,-0.0005);
   ObjectSet("Trix4_OS" + DoubleToStr(WindowId,0),OBJPROP_COLOR,Green);   
   ObjectSet("Trix4_OS" + DoubleToStr(WindowId,0),OBJPROP_STYLE,STYLE_DOT);
   
   ObjectCreate("Trix4_ZERO" + DoubleToStr(WindowId,0),OBJ_HLINE,WindowId,NULL,0.000);
   ObjectSet("Trix4_ZERO" + DoubleToStr(WindowId,0),OBJPROP_COLOR,DimGray);   
   ObjectSet("Trix4_ZERO" + DoubleToStr(WindowId,0),OBJPROP_STYLE,STYLE_DOT);
   
   
   double b2=0,b3=0;
   b2=hot*hot;
   b3=b2*hot;
   c1=-b3;
   c2=(3*(b2+b3));
   c3=-3*(2*b2+hot+b3);
   c4=(1+3*hot+b3+3*b2);
  //Print (" c1 ", c1," c2 ", c2," c3 ", c3," c4 ", c4);

   double n=FastPeriod;
   if (n<1) n=1;
   n = 1 + 0.5*(n-1);
   FastWeight1 = 2 / (n + 1);
   FastWeight2 = 1 - FastWeight1;

   n=SlowPeriod;
   if (n<1) n=1;
   n = 1 + 0.5*(n-1);
   SlowWeight1 = 2 / (n + 1);
   SlowWeight2 = 1 - SlowWeight1;
  
   FirstRun = true;
}
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
   ObDeleteObjectsByPrefix("Trix4");
   return(0);
}
  
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{

   int  shift=0;
   double fastTrix=0,slowTrix=0;
   
   double e1=0,e2=0,e3=0,e4=0,e5=0,e6=0;
   double d1=0,d2=0,d3=0,d4=0,d5=0,d6=0;

   double bar=0, start=0;
   static double prevbars=0; 
   int    counted_bars=IndicatorCounted();

   
   start=Bars-prevbars;
   prevbars = Bars;
   
   if (start==1 || start==0)  bar=start; 
   else 
   {      
      ObDeleteObjectsByPrefix("Trix4_Div");
      FirstRun = true;
      bar = Bars;
   }
 
   shift=bar; 
   while(shift>=0)
   {
      d1 = FastWeight1*Close[shift] + FastWeight2*d1x;
      d2 = FastWeight1*d1 + FastWeight2*d2x;
      d3 = FastWeight1*d2 + FastWeight2*d3x;
      d4 = FastWeight1*d3 + FastWeight2*d4x;
      d5 = FastWeight1*d4 + FastWeight2*d5x;
      d6 = FastWeight1*d5 + FastWeight2*d6x;

      fastTrix = c1*d6 + c2*d5 + c3*d4 + c4*d3;

      e1 = SlowWeight1*Close[shift] + SlowWeight2*e1x;
      e2 = SlowWeight1*e1 + SlowWeight2*e2x;
      e3 = SlowWeight1*e2 + SlowWeight2*e3x;
      e4 = SlowWeight1*e3 + SlowWeight2*e4x;
      e5 = SlowWeight1*e4 + SlowWeight2*e5x;
      e6 = SlowWeight1*e5 + SlowWeight2*e6x;

      slowTrix = c1*e6 + c2*e5 + c3*e4 + c4*e3;

      DrawTrixLines(shift, fastTrix,FastTrixPrev, slowTrix,SlowTrixPrev);
      
      
       //Print (" Shift=", shift," d1x=", d1x," d2x=", d2x," d3x=", d3x," d4x=", d4x," d5x=", d5x," d6x=", d6x, " e1x=", e1x," e2x=", e2x," e3x=", e3x," e4x=", e4x,
       //" e5x=", e5x," e6x=", e6x," FastTrixPrev=", FastTrixPrev," SlowTrixPrev=", SlowTrixPrev);
       //Print (" Shift=", shift," d1=", d1," d2=", d2," d3=", d3," d4=", d4," d5=", d5," d6=", d6);
       //Print (" Time[shift]=", TimeToStr(Time[shift])," Shift=", shift, " FastTrix=", FastTrix," SlowTrix=", SlowTrix, " FastTrixPrev=", FastTrixPrev," SlowTrixPrev=", SlowTrixPrev);
       
       //Print (" Time[shift]=", TimeToStr(Time[shift])," Shift=", shift, " FastTrix=", FastTrix," d3=", d3," d4=", d4," d5=", d5," d6=", d6," c1=", c1," c2=", c2," c3=", c3," c4=", c4);
 
       
      if (shift == 1 || FirstRun)
      {
         d1x=d1;
         d2x=d2;
         d3x=d3;
         d4x=d4;
         d5x=d5;
         d6x=d6; 
         FastTrixPrev=fastTrix;
         SlowTrixPrev=slowTrix; 
         e1x=e1;
         e2x=e2;
         e3x=e3;
         e4x=e4;
         e5x=e5;
         e6x=e6;
      }
      shift--;
   }
   FirstRun = false;

 
}


void DrawTrixLines(int shift, double fastTrix,double fastTrixPrev, double slowTrix,double slowTrixPrev)
{
   if ( slowTrixPrev >0 && fastTrixPrev>0) 
   {
      Fast[shift] = ((fastTrix-fastTrixPrev)/fastTrixPrev) ;
      Slow[shift] = ((slowTrix-slowTrixPrev)/slowTrixPrev) ;
      
      FastUp[shift] = EMPTY_VALUE;
      FastDown[shift] = EMPTY_VALUE;
      SlowUp[shift] = EMPTY_VALUE;
      SlowDown[shift] = EMPTY_VALUE;
      Peak[shift+1] = EMPTY_VALUE;
      Trough[shift+1] = EMPTY_VALUE;
               
      
      ObjectDelete("Trix4_Div" + Time[shift+1]);
      ObjectDelete("Trix4_DivChart" + Time[shift+1]);
      
      //Draw Divergence on Fast Line
      if (Fast[shift] > Fast[shift+1]) 
      {
         FastUp[shift] = Fast[shift];
         if (FastUp[shift+1] == EMPTY_VALUE) 
         { 
            FastUp[shift+1] = Fast[shift+1];
         }         
      }
      else
      {
         FastDown[shift] = Fast[shift];
         if (FastDown[shift+1] == EMPTY_VALUE)
         { 
             FastDown[shift+1] = Fast[shift+1];
         }
      }
      
      //Draw Divergence on Fast Line
      if (ShowDivergence)
      {
         if (Fast[shift] > Fast[shift+1] && Fast[shift+1] < Fast[shift+2]&& Fast[shift+2] < Fast[shift+3])
         {
            FindBullishDivergences(shift);
         }

         if (Fast[shift] < Fast[shift+1] && Fast[shift+1] > Fast[shift+2] && Fast[shift+2] > Fast[shift+3])
         {
            FindBearishDivergences(shift);
         }
      }

      //Draw Slow Line
      if (Slow[shift] > Slow[shift+1])
      {
         SlowUp[shift] = Slow[shift];
         if (SlowUp[shift+1] == EMPTY_VALUE) SlowUp[shift+1] = Slow[shift+1];
      }
      else
      {
         SlowDown[shift] = Slow[shift];
         if (SlowDown[shift+1] == EMPTY_VALUE) SlowDown[shift+1] = Slow[shift+1];
      }
                
   }  
}


void FindBullishDivergences(int shift)
{
   double priceTrough = Low[shift+1];
   for(int i = shift+5; i < shift + 50;i++)
   {
      if (Fast[i] > Fast[i+1] && Fast[i-1] > Fast[i] && Fast[i+1] < Fast[i+2] && Fast[i+2] < Fast[i+3])
      {
         double priceTroughPrev = Low[i+1];
          
         if(priceTroughPrev > priceTrough && Fast[i+1] < Fast[shift+1])
         {
            Trough[shift+1] = Fast[shift+1]-0.00001;
          
            string name = "Trix4_Div" + Time[shift+1];
            string name2 = "Trix4_DivChart" + Time[shift+1];
            if (ShowDivergenceLines)
            {
               ObjectCreate(name, OBJ_TREND,WindowId,Time[i+1],Fast[i+1],Time[shift+1],Fast[shift+1]);
               ObjectSet(name,OBJPROP_COLOR, Green);
               ObjectSet(name,OBJPROP_RAY, false);
            }
            if (ShowDivergencePriceLines)
            {
               ObjectCreate(name2, OBJ_TREND,0,Time[i+1],priceTroughPrev,Time[shift+1],priceTrough);
               ObjectSet(name2,OBJPROP_COLOR, Green);
               ObjectSet(name2,OBJPROP_RAY, false);
            }
            //break;              
         }
         
         if (Fast[i] < Fast[shift+1]+0.0001){break;}
         
      }
      if (Close[i] < priceTrough){break;}
   }
}



void FindBearishDivergences(int shift)
{
   
   double pricePeak = High[shift+1];
   for(int i = shift+5; i < shift + 250;i++)
   {
      if (Fast[i] < Fast[i+1] && Fast[i-1] < Fast[i] && Fast[i+1] > Fast[i+2] && Fast[i+2] > Fast[i+3])
      {
         double pricePeakPrev = High[i+1];
         
         if(pricePeakPrev < pricePeak && Fast[i+1] > Fast[shift+1])
         {
            Peak[shift+1] = Fast[shift+1]+0.00001;
            if (ShowDivergenceLines)
            {
               string name = "Trix4_Div" + Time[shift+1];
               string name2 = "Trix4_DivChart" + Time[shift+1];
               if (ShowDivergenceLines)
               {
                  ObjectCreate(name, OBJ_TREND,WindowId,Time[i+1],Fast[i+1],Time[shift+1],Fast[shift+1]);
                  ObjectSet(name,OBJPROP_COLOR, Red);
                  ObjectSet(name,OBJPROP_RAY, false);
               }
               if (ShowDivergencePriceLines)
               {
                  ObjectCreate(name2, OBJ_TREND,0,Time[i+1],pricePeakPrev,Time[shift+1],pricePeak);
                  ObjectSet(name2,OBJPROP_COLOR, Red);
                  ObjectSet(name2,OBJPROP_RAY, false);
               }
            }
            //break; 
         }
         if (Fast[i] > Fast[shift+1]+0.0001){break;}

      }

      //if (shift<100 && Symbol() == "EURGBPm")      {Print (" Shift ", shift, " i ", i, " High[i] ", High[i], " pricePeak ", pricePeak);}
      if (Close[i] > pricePeak){break;}
   }
}

void ObDeleteObjectsByPrefix(string Prefix)
  {
   int L = StringLen(Prefix);
   int i = 0; 
   while(i < ObjectsTotal())
     {
       string ObjName = ObjectName(i);
       if(StringSubstr(ObjName, 0, L) != Prefix) 
         { 
           i++; 
           continue;
         }
       ObjectDelete(ObjName);
     }
  }
  string ObGetUniqueName(string Prefix)
  {
   ObjectId++;
   return (Prefix+" "+DoubleToStr(ObjectId, 0));
  }